function varargout = nemo(varargin)
% NEMO M-file for nemo.fig
%      NEMO, by itself, creates a new NEMO or raises the existing
%      singleton*.
%
%      H = NEMO returns the handle to a new NEMO or the handle to
%      the existing singleton*.
%
%      NEMO('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in NEMO.M with the given input arguments.
%
%      NEMO('Property','Value',...) creates a new NEMO or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before nemo_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to nemo_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%%   COPYRIGHT:  George D. Tsibidis(1) and Nektarios Tavernarakis(2)
%               (1) Institute of Electronic Structure and Laser 
%               (2) Institute of Molecular Biology and Biotechnology 
%               Foundation for Research and Technology-Hellas (FORTH)
%               January 2007

%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help nemo

% Last Modified by GUIDE v2.5 11-Jan-2007 13:47:22

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @nemo_OpeningFcn, ...
                   'gui_OutputFcn',  @nemo_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin & isstr(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


DIRECTORY='C:\Documents and Settings\George Tsibidis\Desktop\C-elegans New videos\New set\DATA subset';




% --- Executes just before nemo is made visible.
function nemo_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to nemo (see VARARGIN)

% Choose default command line output for nemo
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes nemo wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = nemo_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes during object creation, after setting all properties.
function edit1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% --- Executes during object creation, after setting all properties.
function popupmenu2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on selection change in popupmenu2.
function popupmenu2_Callback(hObject, eventdata, handles)
% choose directory where images that will be used have been saved
% hObject    handle to popupmenu2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenu2 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu2


global DIRECTORY
global choose_display
global period
global point_period
global ROW
global COLUMN
global frames_per_sec
global Y_ROW_MM
global X_COLUMN_MM
global one_pixel_mm


choose_display=1;

off = [handles.radiobutton2];
set(off,'Value',1)
off = [handles.radiobutton1];
set(off,'Value',0)

numb_time103=findobj(gcbf,'Tag','edit1');
     set(numb_time103,'String',sprintf('%5.0f',''))
     numb_time103=findobj(gcbf,'Tag','edit3');
     set(numb_time103,'String',sprintf('%5.0f',''))
     numb_time103=findobj(gcbf,'Tag','edit4');
     set(numb_time103,'String',sprintf('%5.0f',''))
     

q=(get(hObject,'Value'));


choose_display=q;
switch q
    
    case 1  % only image
DIRECTORY='C:\Documents and Settings\George Tsibidis\Desktop\C-elegans New videos\New set\DATA subset';
period=95:431;
length_animal=1; %mm

image1=imread([int2str(period(1)) '.jpg']);
SIZEimage=size(image1);


%ROW=SIZEimage(1);
%COLUMN=SIZEimage(2);

end 

cd ([DIRECTORY '/DATA_SAVED/'])

point_period=load('number_of_time_points.txt');

BRC=load('background_row_column.txt');
ROW=BRC(2);
COLUMN=BRC(3);

    time_umb_ini=findobj(gcbf,'Tag','edit8');
     set(time_umb_ini,'String',sprintf('%s',char([int2str(min(period)) '--' int2str(max(period))])))
      time_umb_ini=findobj(gcbf,'Tag','edit9');
     set(time_umb_ini,'String',sprintf('%s',char([int2str(load('number_of_time_points.txt'))])))
frames_per_sec=load('frames_per_sec.txt');
time_umb_ini=findobj(gcbf,'Tag','edit18');
     set(time_umb_ini,'String',sprintf('%s',char([int2str(frames_per_sec)])));

     
     
    time_umb_ini=findobj(gcbf,'Tag','edit19');
     set(time_umb_ini,'String',sprintf('%s',char([int2str(ROW) 'x' int2str(COLUMN)])));


    LENGTH=[];
    for i=period(1):period(end)
    LENGTH=[LENGTH,load(['length_' int2str(i) '.txt'])];    
    end
    
    
    time_umb_ini=findobj(gcbf,'Tag','edit20');
     set(time_umb_ini,'String',sprintf('%s',char([int2str(ROW*length_animal/mean(LENGTH)) ...
             'x' int2str(COLUMN*length_animal/mean(LENGTH))])));
Y_ROW_MM=ROW*length_animal/mean(LENGTH);
     X_COLUMN_MM=COLUMN*length_animal/mean(LENGTH);
     one_pixel_mm=length_animal/mean(LENGTH);

cd (DIRECTORY)

function popupmenu1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on selection change in popupmenu1.
function choose_display_Callback(hObject, eventdata, handles)
% this function defines what kind of images we wilke to see (with
% perimeter, backbone etc)

% hObject    handle to popupmenu1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenu1 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu1

global choose_display

q=(get(hObject,'Value'));

choose_display=q;
switch q
    
    case 1  % only image

    case 2    % worm with backbone
  
    
    case 3     % only perimeter
        
    case 4    % perimetr+bacbone
        
    case 5  % all above
end    
    






function image_Callback(hObject, eventdata, handles)
% choose image for which we want to display perimeter+backbone etc
%
%
% hObject    handle to edit1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit1 as text
%        str2double(get(hObject,'String')) returns contents of edit1 as a double

global time
global period
global DIRECTORY
global choose_display
global axis_handle
global saved
global ROW
global COLUMN
global frames_per_sec
global Y_ROW_MM
global X_COLUMN_MM
global one_pixel_mm


%numb_time101=findobj(gcbf,'Tag','edit1');
%set(numb_time101,'String',sprintf('%4.0f','')) ;
one_pixel_mm


%period=1:44;
time=str2double(get(hObject,'string'));

if isnan(time)
         errordlg('You must enter a numeric value','Bad Input','modal')
elseif ~isnan(time)
    
     if time>max(period)| time<min(period)
         errordlg('Out of Range', 'Try again','modal')
            
     else
     
         time=time;   % acceptable value
         cd ('DATA_SAVED')
         time_umb_ini=findobj(gcbf,'Tag','edit15');
     set(time_umb_ini,'String',sprintf('%s',char([num2str(one_pixel_mm*one_pixel_mm*(load(['area_' int2str(time) '.txt'])))])))
         
           time_umb_ini=findobj(gcbf,'Tag','edit17');
     set(time_umb_ini,'String',sprintf('%s',char([num2str(one_pixel_mm*(load(['length_' int2str(time) '.txt'])))])))
     
     % width
     
     number_of_segments=load('number_of_time_points.txt');
     
     width=[];
     for k=2:number_of_segments-1
         width=[width,load(['thickeness_image=' int2str(time) '_segment=' int2str(k) '.txt'])];
     end
 
     time_umb_ini=findobj(gcbf,'Tag','edit16');
     set(time_umb_ini,'String',sprintf('%s',char([num2str(2*one_pixel_mm*mean(width))])));
     cd ..
         
         % load image
         if choose_display==1
         cd (DIRECTORY)
         IMAGE=imread([int2str(time) '.jpg']);
         
         size(IMAGE)
         figure;axis_handle = axes;imshow(IMAGE);title(['time moment = ' int2str(time)]); 
         hold on;
     elseif choose_display==2
         
         cd (DIRECTORY)
         IMAGE=imread([int2str(time) '.jpg']);
         IMAGE=rgb2gray(IMAGE);
         figure;axis_handle = axes;imshow(IMAGE);title(['time moment = ' int2str(time)]); 
         hold on;
         cd ('DATA_SAVED')
        BW=load(['mask_' int2str(time)]);
        BW=bwperim(BW,8);
        x=[];y=[];
        [r,c]=find(BW==1);
        
       % for k=1:length(r)
        %    x=[x,c(k)];
         %   y=[y,r(k)];
         %end
           x=c;
      y=r;
plot(x,y,'g.'); 

%load bacbone
elseif choose_display==3
    cd (DIRECTORY)
         IMAGE=imread([int2str(time) '.jpg']);
         figure;axis_handle = axes;imshow(IMAGE);title(['time moment = ' int2str(time)]); 
         hold on;
         
         if saved==0
         cd ('DATA_SAVED')
     else
         cd ('DATA_SAVED')
     end
        BW=load(['skeleton_' int2str(time)]);
        x=[];y=[];
        [r,c]=find(BW==1);
        
    %    for k=1:length(r)
     %       x=[x,c(k)];
      %      y=[y,r(k)];
      % end
        x=c;
      y=r;
plot(x,y,'r.');    

elseif choose_display==4
    cd (DIRECTORY)
         IMAGE=imread([int2str(time) '.jpg']);
         figure;axis_handle = axes;imshow(IMAGE);title(['time moment = ' int2str(time)]); 
         hold on;
        if saved==0
         cd ('DATA_SAVED')
     else
         cd ('DATA_SAVED')
     end
        BW=load(['skeleton_' int2str(time)]);
        x=[];y=[];
        [r,c]=find(BW==1);
        
      %  for k=1:length(r)
       %     x=[x,c(k)];
         %   y=[y,r(k)];
         %end
            x=c;
      y=r;
plot(x,y,'r.');  hold on;

cd ([DIRECTORY '/DATA_SAVED/'])

        BW=load(['mask_' int2str(time)]);
        BW=bwperim(BW,8);
        x=[];y=[];
        [r,c]=find(BW==1);
        
    %    for k=1:length(r)
     %       x=[x,c(k)];
      %      y=[y,r(k)];
      % end
      x=c;
      y=r;
plot(x,y,'g.');     
    

    
    
    
     end
 end
end
cd (DIRECTORY)
% --- Executes on button press in pushbutton1.
function back_image_Callback(hObject, eventdata, handles)
% choose image for which we want to display perimeter+backbone etc
% go back in time
% hObject    handle to pushbutton1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

global time
global period
global DIRECTORY
global choose_display
global axis_handle
global saved 
global ROW
global COLUMN
global frames_per_sec
global Y_ROW_MM
global X_COLUMN_MM
global one_pixel_mm


time=time-1;
   if time<min(period)
         errordlg('Out of Range', 'Try again','modal')
         
         
     else

         numb_time101=findobj(gcbf,'Tag','edit1');
set(numb_time101,'String',sprintf('%4.0f',time)) ;

  cd ('DATA_SAVED')
         time_umb_ini=findobj(gcbf,'Tag','edit15');
     set(time_umb_ini,'String',sprintf('%s',char([num2str(one_pixel_mm*one_pixel_mm*(load(['area_' int2str(time) '.txt'])))])))
             time_umb_ini=findobj(gcbf,'Tag','edit17');
     set(time_umb_ini,'String',sprintf('%s',char([num2str(one_pixel_mm*(load(['length_' int2str(time) '.txt'])))])))
     % width
     
     number_of_segments=load('number_of_time_points.txt');
     
     width=[];
     for k=2:number_of_segments-1
         width=[width,load(['thickeness_image=' int2str(time) '_segment=' int2str(k) '.txt'])];
     end
 
     time_umb_ini=findobj(gcbf,'Tag','edit16');
     set(time_umb_ini,'String',sprintf('%s',char([num2str(2*one_pixel_mm*mean(width))])));
         
         cd ..


 if choose_display==1
% load image

cd (DIRECTORY)
         IMAGE=imread([int2str(time) '.jpg']);
        axes(axis_handle);hold off;imshow(IMAGE);title(['time moment = ' int2str(time)]); hold on;
%load bacbone
elseif choose_display==2
  cd (DIRECTORY)
         IMAGE=imread([int2str(time) '.jpg']);
       axes(axis_handle);hold off;imshow(IMAGE);title(['time moment = ' int2str(time)]); 
         hold on;
         cd ('DATA_SAVED')
        BW=load(['mask_' int2str(time)]);
        BW=bwperim(BW,8);
        x=[];y=[];
        [r,c]=find(BW==1);
        
       % for k=1:length(r)
        %    x=[x,c(k)];
         %   y=[y,r(k)];
         %end
           x=c;
      y=r;
plot(x,y,'g.');          
        
%load bacbone
%load bacbone
elseif choose_display==3
    cd (DIRECTORY)
         IMAGE=imread([int2str(time) '.jpg']);
       axes(axis_handle);hold off;imshow(IMAGE);title(['time moment = ' int2str(time)]); 
         hold on;
         if saved==0
         cd ('DATA_SAVED')
     else
         cd ('DATA_SAVED')
     end
        BW=load(['skeleton_' int2str(time)]);
      
        x=[];y=[];
        [r,c]=find(BW==1);
        
       % for k=1:length(r)
        %    x=[x,c(k)];
         %   y=[y,r(k)];
         %end
           x=c;
      y=r;
plot(x,y,'r.');   

elseif choose_display==4
cd (DIRECTORY)
         IMAGE=imread([int2str(time) '.jpg']);
       axes(axis_handle);hold off;imshow(IMAGE);title(['time moment = ' int2str(time)]); 
         hold on;
         if saved==0
         cd ('DATA_SAVED')
     else
         cd ('DATA_SAVED')
     end
        BW=load(['skeleton_' int2str(time)]);
        x=[];y=[];
        [r,c]=find(BW==1);
         x=c;
      y=r; 
      %  for k=1:length(r)
       %     x=[x,c(k)];
        %    y=[y,r(k)];
        %end
plot(x,y,'r.');  hold on;
cd ([DIRECTORY '/DATA_SAVED/'])
        BW=load(['mask_' int2str(time)]);
        BW=bwperim(BW,8);
        x=[];y=[];
        [r,c]=find(BW==1);
          x=c;
      y=r;
     %   for k=1:length(r)
      %      x=[x,c(k)];
       %     y=[y,r(k)];
       %end
plot(x,y,'g.');     
    

    
    
    


end
     end
     
cd (DIRECTORY)
% --- Executes on button press in pushbutton2.
function front_image_Callback(hObject, eventdata, handles)
% choose image for which we want to display perimeter+backbone etc
% go forwards in time
% hObject    handle to pushbutton2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

global choose_display
global time
global period
global DIRECTORY
global axis_handle
global saved
global ROW
global COLUMN
global frames_per_sec
global Y_ROW_MM
global X_COLUMN_MM
global one_pixel_mm

time=time+1;
   if time>max(period)
         errordlg('Out of Range', 'Try again','modal')
         
         
     else
         
         numb_time101=findobj(gcbf,'Tag','edit1');
set(numb_time101,'String',sprintf('%4.0f',time)) ;

  cd ('DATA_SAVED')
         time_umb_ini=findobj(gcbf,'Tag','edit15');
     set(time_umb_ini,'String',sprintf('%s',char([num2str((one_pixel_mm*one_pixel_mm*load(['area_' int2str(time) '.txt'])))])))
             time_umb_ini=findobj(gcbf,'Tag','edit17');
     set(time_umb_ini,'String',sprintf('%s',char([num2str((one_pixel_mm*load(['length_' int2str(time) '.txt'])))])))
     % width
     
     number_of_segments=load('number_of_time_points.txt');
     
     width=[];
     for k=2:number_of_segments-1
         width=[width,load(['thickeness_image=' int2str(time) '_segment=' int2str(k) '.txt'])];
     end
 
     time_umb_ini=findobj(gcbf,'Tag','edit16');
     set(time_umb_ini,'String',sprintf('%s',char([num2str(2*one_pixel_mm*mean(width))])));
         
         cd ..


 if choose_display==1
% load image
cd (DIRECTORY)
         IMAGE=imread([int2str(time) '.jpg']);
    axes(axis_handle);hold off;  imshow(IMAGE);title(['time moment = ' int2str(time)]); hold on;
%load bacbone
elseif choose_display==2
   cd (DIRECTORY)
         IMAGE=imread([int2str(time) '.jpg']);
       axes(axis_handle);hold off;imshow(IMAGE);title(['time moment = ' int2str(time)]); 
         hold on;
         cd ('DATA_SAVED')
        BW=load(['mask_' int2str(time)]);
        BW=bwperim(BW,8);
        x=[];y=[];
        [r,c]=find(BW==1);
    x=c;
      y=r;      
    %    for k=1:length(r)
     %       x=[x,c(k)];
      %      y=[y,r(k)];
      % end
plot(x,y,'g.');  
%load bacbone
elseif choose_display==3
   cd (DIRECTORY)
         IMAGE=imread([int2str(time) '.jpg']);
       axes(axis_handle);hold off;imshow(IMAGE);title(['time moment = ' int2str(time)]); 
         hold on;
         if saved==0
         cd ('DATA_SAVED')
     else
         cd ('DATA_SAVED')
     end
        BW=load(['skeleton_' int2str(time)]);
      
        x=[];y=[];
        [r,c]=find(BW==1);
          x=c;
      y=r;
        %for k=1:length(r)
         %   x=[x,c(k)];
          %  y=[y,r(k)];
          %end
plot(x,y,'r.');  



elseif choose_display==4
cd (DIRECTORY)
         IMAGE=imread([int2str(time) '.jpg']);
       axes(axis_handle);hold off;imshow(IMAGE);title(['time moment = ' int2str(time)]); 
         hold on;
         if saved==0
         cd ('DATA_SAVED')
     else
         
         cd ('DATA_SAVED')
     end
        BW=load(['skeleton_' int2str(time)]);
        x=[];y=[];
        [r,c]=find(BW==1);
          x=c;
      y=r;
      %  for k=1:length(r)
       %     x=[x,c(k)];
        %    y=[y,r(k)];
        %end
plot(x,y,'r.');  hold on;
cd ([DIRECTORY '/DATA_SAVED/'])
        BW=load(['mask_' int2str(time)]);
        BW=bwperim(BW,8);
        x=[];y=[];
        [r,c]=find(BW==1);
          x=c;
      y=r;
        %for k=1:length(r)
         %   x=[x,c(k)];
          %  y=[y,r(k)];
          %end
plot(x,y,'g.');     
    

    
    
    




end
     end
     
 cd (DIRECTORY)


% --- Executes on button press in radiobutton1.
function initial_radiobutton_Callback(hObject, eventdata, handles)
global saved

saved=0;

off = [handles.radiobutton1];
set(off,'Value',1)
off = [handles.radiobutton2];
set(off,'Value',0)

% hObject    handle to radiobutton1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radiobutton1


% --- Executes on button press in radiobutton2.
function saved_radiobutton_Callback(hObject, eventdata, handles)
global saved 

saved=1;

off = [handles.radiobutton1];
set(off,'Value',0)
off = [handles.radiobutton2];
set(off,'Value',1)
% hObject    handle to radiobutton2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radiobutton2


% --- Executes during object creation, after setting all properties.
function backbone_popupmenu4_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on selection change in popupmenu4.
function backbone_popupmenu4_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenu4 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu4
global choose_display_line
global DIRECTORY


q=(get(hObject,'Value'));

choose_display_line=q;
switch q
    
    case 1  % backbone points

    case 2    % CM
  
    
    case 3     % CM with labels 
        
    case 4    % backbone with CMs
        
    case 5
    case 6
    case 7
     
end    
    

cd (DIRECTORY)


% --- Executes during object creation, after setting all properties.
function backbone_time_edit3_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function backbone_time_edit3_Callback(hObject, eventdata, handles)
% hObject    handle to edit3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit3 as text
%        str2double(get(hObject,'String')) returns contents of edit3 as a double
global time
global period
global DIRECTORY
global choose_display_line
global axis_handle
 
global point_period


time=str2double(get(hObject,'string'));

if isnan(time)
         errordlg('You must enter a numeric value','Bad Input','modal')
elseif ~isnan(time)
    
     if time>max(period)| time<min(period)
         errordlg('Out of Range', 'Try again','modal')
            
     else
     
         time=time;   % acceptable value
         
         % load image
         if choose_display_line==1   %%%  line
         cd (DIRECTORY)
         
         IMAGE=imread([int2str(time) '.jpg']);
        % IMAGE=rgb2gray(IMAGE);
         figure;axis_handle = axes;imshow(IMAGE);title(['time moment = ' int2str(time)]); 
         hold on;
         cd ('DATA_SAVED')
         for k=1:point_period
            
            line=load(['skeleton_' int2str(time) '_line=' int2str(k) '.txt']);
            if mod(k,2)==0
                  plot(line(2,:),line(1,:),'g.'); 
                  hold on;
            else
                             plot(line(2,:),line(1,:),'b.'); hold on;
            end
            
        end
        
          

        
         
         
         
     elseif choose_display_line==2   %%% CM
         
         cd (DIRECTORY)
         IMAGE=imread([int2str(time) '.jpg']);
         IMAGE=rgb2gray(IMAGE);
         figure;axis_handle = axes;imshow(IMAGE);title(['time moment = ' int2str(time)]); 
         hold on;
         cd ('DATA_SAVED')
         CM1=[];
        for k=1:point_period
            
            CM=load(['skeleton_' int2str(time) '_point=' int2str(k) '.txt']);
            CM1=[CM1,CM];
            
        end
        
         
         
         
plot(CM1(2,:),CM1(1,:),'r*'); 


%load bacbone
elseif choose_display_line==3  %%% CM +labels
    cd (DIRECTORY)
         IMAGE=imread([int2str(time) '.jpg']);
         figure;axis_handle = axes;imshow(IMAGE);title(['time moment = ' int2str(time)]); 
         hold on;
       cd ('DATA_SAVED')
        
        for k=1:point_period
            
            CM=load(['skeleton_' int2str(time) '_point=' int2str(k) '.txt']);
            
        plot(CM(2),CM(1),'r*'); hold on;    
        h=text(CM(2),CM(1), ['\leftarrow' int2str(k)] );
set(h,'FontSize',10);
set(h, 'FontWeight', 'light')
set(h,'Color','m')
        
        end
        
        elseif choose_display_line==4
    cd (DIRECTORY)
         IMAGE=imread([int2str(time) '.jpg']);
         figure;axis_handle = axes;imshow(IMAGE);title(['time moment = ' int2str(time)]); 
         hold on;
        cd ('DATA_SAVED')
         for k=1:point_period
            
            line=load(['skeleton_' int2str(time) '_line=' int2str(k) '.txt']);
            if mod(k,2)==0
                  plot(line(2,:),line(1,:),'g.'); 
                  hold on;
            else
                             plot(line(2,:),line(1,:),'b.'); hold on;
            end
            
        end
        
          for k=1:point_period
            
            CM=load(['skeleton_' int2str(time) '_point=' int2str(k) '.txt']);
            
        plot(CM(2),CM(1),'r*'); hold on;    
    
        
        end


    
     
         


elseif choose_display_line==5
    cd (DIRECTORY)
         IMAGE=imread([int2str(time) '.jpg']);
         figure;axis_handle = axes;imshow(IMAGE);title(['time moment = ' int2str(time)]); 
         hold on;
        cd ('DATA_SAVED')
         for k=1:point_period
            
            line=load(['skeleton_' int2str(time) '_line=' int2str(k) '.txt']);
            if mod(k,2)==0
                  plot(line(2,:),line(1,:),'g.'); 
                  hold on;
            else
                             plot(line(2,:),line(1,:),'b.'); hold on;
            end
            
        end
        
          for k=1:point_period
            
            CM=load(['skeleton_' int2str(time) '_point=' int2str(k) '.txt']);
            
        plot(CM(2),CM(1),'r*'); hold on;    
        h=text(CM(2),CM(1), ['\leftarrow' int2str(k)] );
set(h,'FontSize',10);
set(h, 'FontWeight', 'light')
set(h,'Color','m')
        
        end


    elseif choose_display_line==7
        
        cd (DIRECTORY)
         IMAGE=imread([int2str(time) '.jpg']);
         %IMAGE=rgb2gray(IMAGE);
         figure;axis_handle = axes;imshow(IMAGE);title(['time moment = ' int2str(time)]); 
         hold on;
        cd ('DATA_SAVED')
        
        Q=[];
        
         for k=1:point_period
            
            line=load(['skeleton_' int2str(time) '_line=' int2str(k) '.txt']);
            if mod(k,2)==0
                  plot(line(2,:),line(1,:),'g.'); 
                  hold on;
            else
                             plot(line(2,:),line(1,:),'b.'); hold on;
                             
                            
            end
            
             if k==1
            line=load(['skeleton_' int2str(time) '_line=' int2str(k) '.txt']);
            Q=[Q,[line(1,1); line(2,1)]];
        end
         if k==point_period
            line=load(['skeleton_' int2str(time) '_line=' int2str(k) '.txt']);
            Q=[Q,[line(1,end); line(2,end)]];
        end
            
            
        end
        CM=load(['skeleton_' int2str(time) '_total_point=' int2str(point_period) '.txt']);
        
       hold on;
       plot(CM(2),CM(1),'m*');
 
 elseif choose_display_line==6
 
 
 
 cd (DIRECTORY)
         IMAGE=imread([int2str(time) '.jpg']);
         %IMAGE=rgb2gray(IMAGE);
         figure;axis_handle = axes;imshow(IMAGE);title(['time moment = ' int2str(time)]); 
         hold on;
        cd ('DATA_SAVED')
        
        Q=[];
        
         for k=1:point_period
            
            line=load(['skeleton_' int2str(time) '_line=' int2str(k) '.txt']);
            if mod(k,2)==0
                  plot(line(2,:),line(1,:),'g.'); 
                  hold on;
            else
                             plot(line(2,:),line(1,:),'b.'); hold on;
                             
                             if k==5
                             
                                   plot(line(2,end),line(1,end),'m*'); hold on;
                                   RO=line(1,end);
                                   CO=line(2,end);
                             end
            end
            
             if k==1
            line=load(['skeleton_' int2str(time) '_line=' int2str(k) '.txt']);
            Q=[Q,[line(1,1); line(2,1)]];
        end
         if k==point_period
            line=load(['skeleton_' int2str(time) '_line=' int2str(k) '.txt']);
            Q=[Q,[line(1,end); line(2,end)]];
        end
            
            
        end
        
       
        
        RC=Q;
        tanphi=((RC(1,2)-RC(1,1))/(RC(2,2)-RC(2,1)));
        beta=RO-tanphi*CO;
        
        hold on;plot([0 CO],[beta RO],'g-.');hold on; plot([CO 5*CO],[RO (tanphi*5*CO+RO)],'g-.');
        hold on;plot([RC(2,1) RC(2,2)],[RC(1,1) RC(1,2)],'r');hold on;plot(RC(2,1),RC(1,1),'r*' );hold on;plot(RC(2,2),RC(1,2),'r*' );
      
        
  
    
    
     end
 end
end
cd (DIRECTORY)







% --- Executes on button press in pushbutton3.
function backbone_b_pushbutton3_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

global DIRECTORY
global period
global time
global time
global period
global DIRECTORY
global choose_display_line
global axis_handle
 
global point_period

time=time-1;
 if time<min(period)
         errordlg('Out of Range', 'Try again','modal')
         
         
     else

         numb_time101=findobj(gcbf,'Tag','edit3');
set(numb_time101,'String',sprintf('%4.0f',time)) ;
time=time;   % acceptable value
         
         % load image
         if choose_display_line==1   %%%  line
         cd (DIRECTORY)
         IMAGE=imread([int2str(time) '.jpg']);
         axes(axis_handle);hold off;imshow(IMAGE);title(['time moment = ' int2str(time)]); 
         hold on;
         cd ('DATA_SAVED')
         for k=1:point_period
            
            line=load(['skeleton_' int2str(time) '_line=' int2str(k) '.txt']);
            if mod(k,2)==0
                  plot(line(2,:),line(1,:),'g.'); 
                  hold on;
            else
                             plot(line(2,:),line(1,:),'b.'); hold on;
            end
            
        end
        
          
elseif choose_display_line==7
        
        cd (DIRECTORY)
         IMAGE=imread([int2str(time) '.jpg']);
      axes(axis_handle);hold off;imshow(IMAGE);title(['time moment = ' int2str(time)]); 
         hold on;
        cd ('DATA_SAVED')
        
        Q=[];
        
         for k=1:point_period
            
            line=load(['skeleton_' int2str(time) '_line=' int2str(k) '.txt']);
            if mod(k,2)==0
                  plot(line(2,:),line(1,:),'g.'); 
                  hold on;
            else
                             plot(line(2,:),line(1,:),'b.'); hold on;
                             
                            
            end
            
             if k==1
            line=load(['skeleton_' int2str(time) '_line=' int2str(k) '.txt']);
            Q=[Q,[line(1,1); line(2,1)]];
        end
         if k==point_period
            line=load(['skeleton_' int2str(time) '_line=' int2str(k) '.txt']);
            Q=[Q,[line(1,end); line(2,end)]];
        end
            
            
        end
        CM=load(['skeleton_' int2str(time) '_total_point=' int2str(point_period) '.txt']);
        
       hold on;
       plot(CM(2),CM(1),'m*');
 
        
        
        
        
         
         
         
     elseif choose_display_line==2   %%% CM
         
         cd (DIRECTORY)
         IMAGE=imread([int2str(time) '.jpg']);
        axes(axis_handle);hold off;imshow(IMAGE);title(['time moment = ' int2str(time)]); 
         hold on;
         cd ('DATA_SAVED')
         CM1=[];
        for k=1:point_period
            
            CM=load(['skeleton_' int2str(time) '_point=' int2str(k) '.txt']);
            CM1=[CM1,CM];
            
        end
        
         
         
         
plot(CM1(2,:),CM1(1,:),'r*'); 


%load bacbone
elseif choose_display_line==3  %%% CM +labels
    cd (DIRECTORY)
         IMAGE=imread([int2str(time) '.jpg']);
       axes(axis_handle);hold off;imshow(IMAGE);title(['time moment = ' int2str(time)]); 
         hold on;
       cd ('DATA_SAVED')
        
        for k=1:point_period
            
            CM=load(['skeleton_' int2str(time) '_point=' int2str(k) '.txt']);
            
        plot(CM(2),CM(1),'r*'); hold on;    
        h=text(CM(2),CM(1), ['\leftarrow' int2str(k)] );
set(h,'FontSize',10);
set(h, 'FontWeight', 'light')
set(h,'Color','m')
        
        end
        
         elseif choose_display_line==4
    cd (DIRECTORY)
         IMAGE=imread([int2str(time) '.jpg']);
        axes(axis_handle);hold off;imshow(IMAGE);title(['time moment = ' int2str(time)]); 
         hold on;
        cd ('DATA_SAVED')
         for k=1:point_period
            
            line=load(['skeleton_' int2str(time) '_line=' int2str(k) '.txt']);
            if mod(k,2)==0
                  plot(line(2,:),line(1,:),'g.'); 
                  hold on;
            else
                             plot(line(2,:),line(1,:),'b.'); hold on;
            end
            
        end
        
          for k=1:point_period
            
            CM=load(['skeleton_' int2str(time) '_point=' int2str(k) '.txt']);
            
        plot(CM(2),CM(1),'r*'); hold on;    
        
        
        end


    
    
         


elseif choose_display_line==5
    cd (DIRECTORY)
         IMAGE=imread([int2str(time) '.jpg']);
 axes(axis_handle);hold off;imshow(IMAGE);title(['time moment = ' int2str(time)]); 
         hold on;
        cd ('DATA_SAVED')
         for k=1:point_period
            
            line=load(['skeleton_' int2str(time) '_line=' int2str(k) '.txt']);
            if mod(k,2)==0
                  plot(line(2,:),line(1,:),'g.'); 
                  hold on;
            else
                             plot(line(2,:),line(1,:),'b.'); hold on;
            end
            
        end
        
          for k=1:point_period
            
            CM=load(['skeleton_' int2str(time) '_point=' int2str(k) '.txt']);
            
        plot(CM(2),CM(1),'r*'); hold on;    
        h=text(CM(2),CM(1), ['\leftarrow' int2str(k)] );
set(h,'FontSize',10);
set(h, 'FontWeight', 'light')
set(h,'Color','m')
        
        end


    
    
    
     end



end
cd (DIRECTORY)

% --- Executes on button press in pushbutton4.
function backbone_f_pushbutton4_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

global DIRECTORY
global period
global time
global time
global period
global DIRECTORY
global choose_display_line
global axis_handle
 
global point_period

time=time+1;

if time>max(period)
         errordlg('Out of Range', 'Try again','modal')
         
         
     else

         numb_time101=findobj(gcbf,'Tag','edit3');
set(numb_time101,'String',sprintf('%4.0f',time)) ;

time=time;   % acceptable value
         
         % load image
         if choose_display_line==1   %%%  line
         cd (DIRECTORY)
         IMAGE=imread([int2str(time) '.jpg']);
       axes(axis_handle);hold off;imshow(IMAGE);title(['time moment = ' int2str(time)]); 
         hold on;
         cd ('DATA_SAVED')
         for k=1:point_period
            
            line=load(['skeleton_' int2str(time) '_line=' int2str(k) '.txt']);
            if mod(k,2)==0
                  plot(line(2,:),line(1,:),'g.'); 
                  hold on;
            else
                             plot(line(2,:),line(1,:),'b.'); hold on;
            end
            
        end
        
          
        
        
    elseif choose_display_line==7
        
        cd (DIRECTORY)
         IMAGE=imread([int2str(time) '.jpg']);
          axes(axis_handle);hold off;imshow(IMAGE);title(['time moment = ' int2str(time)]); 
         hold on;
        cd ('DATA_SAVED')
        
        Q=[];
        
         for k=1:point_period
            
            line=load(['skeleton_' int2str(time) '_line=' int2str(k) '.txt']);
            if mod(k,2)==0
                  plot(line(2,:),line(1,:),'g.'); 
                  hold on;
            else
                             plot(line(2,:),line(1,:),'b.'); hold on;
                             
                            
            end
            
             if k==1
            line=load(['skeleton_' int2str(time) '_line=' int2str(k) '.txt']);
            Q=[Q,[line(1,1); line(2,1)]];
        end
         if k==point_period
            line=load(['skeleton_' int2str(time) '_line=' int2str(k) '.txt']);
            Q=[Q,[line(1,end); line(2,end)]];
        end
            
            
        end
        CM=load(['skeleton_' int2str(time) '_total_point=' int2str(point_period) '.txt']);
        
       hold on;
       plot(CM(2),CM(1),'m*');

        
         
         
         
     elseif choose_display_line==2   %%% CM
         
         cd (DIRECTORY)
         IMAGE=imread([int2str(time) '.jpg']);
         axes(axis_handle);hold off;imshow(IMAGE);title(['time moment = ' int2str(time)]); 
         hold on;
         cd ('DATA_SAVED')
         CM1=[];
        for k=1:point_period
            
            CM=load(['skeleton_' int2str(time) '_point=' int2str(k) '.txt']);
            CM1=[CM1,CM];
            
        end
        
         
         
         
plot(CM1(2,:),CM1(1,:),'r*'); 


%load bacbone
elseif choose_display_line==3  %%% CM +labels
    cd (DIRECTORY)
         IMAGE=imread([int2str(time) '.jpg']);
         axes(axis_handle);hold off;imshow(IMAGE);title(['time moment = ' int2str(time)]); 
         hold on;
       cd ('DATA_SAVED')
        
        for k=1:point_period
            
            CM=load(['skeleton_' int2str(time) '_point=' int2str(k) '.txt']);
            
        plot(CM(2),CM(1),'r*'); hold on;    
        h=text(CM(2),CM(1), ['\leftarrow' int2str(k)] );
set(h,'FontSize',10);
set(h, 'FontWeight', 'light')
set(h,'Color','m')
        
        end
        
         
         elseif choose_display_line==4
    cd (DIRECTORY)
         IMAGE=imread([int2str(time) '.jpg']);
      axes(axis_handle);hold off;imshow(IMAGE);title(['time moment = ' int2str(time)]); 
         hold on;
        cd ('DATA_SAVED')
         for k=1:point_period
            
            line=load(['skeleton_' int2str(time) '_line=' int2str(k) '.txt']);
            if mod(k,2)==0
                  plot(line(2,:),line(1,:),'g.'); 
                  hold on;
            else
                             plot(line(2,:),line(1,:),'b.'); hold on;
            end
            
        end
        
          for k=1:point_period
            
            CM=load(['skeleton_' int2str(time) '_point=' int2str(k) '.txt']);
            
        plot(CM(2),CM(1),'r*'); hold on;    
        
        
        end


    
    
    


elseif choose_display_line==5
    cd (DIRECTORY)
         IMAGE=imread([int2str(time) '.jpg']);
axes(axis_handle);hold off;imshow(IMAGE);title(['time moment = ' int2str(time)]); 
         hold on;
        cd ('DATA_SAVED')
         for k=1:point_period
            
            line=load(['skeleton_' int2str(time) '_line=' int2str(k) '.txt']);
            if mod(k,2)==0
                  plot(line(2,:),line(1,:),'g.'); 
                  hold on;
            else
                             plot(line(2,:),line(1,:),'b.'); hold on;
            end
            
        end
        
          for k=1:point_period
            
            CM=load(['skeleton_' int2str(time) '_point=' int2str(k) '.txt']);
            
        plot(CM(2),CM(1),'r*'); hold on;    
        h=text(CM(2),CM(1), ['\leftarrow' int2str(k)] );
set(h,'FontSize',10);
set(h, 'FontWeight', 'light')
set(h,'Color','m')
        
        end


    
    
    
     end


end

cd (DIRECTORY)

% --- Executes during object creation, after setting all properties.
function point_edit4_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function point_edit4_Callback(hObject, eventdata, handles)
% hObject    handle to edit4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit4 as text
%        str2double(get(hObject,'String')) returns contents of edit4 as a double

global point
global point_period
global DIRECTORY
                            
point=str2double(get(hObject,'string'))

if isnan(point)
         errordlg('You must enter a numeric value','Bad Input','modal')
elseif ~isnan(point)
   
     if point>max(1:point_period)|point<min(1:point_period)
         errordlg('Out of Range', 'Try again','modal')
            
     else
         
     end
 end

cd (DIRECTORY)


% --- Executes during object creation, after setting all properties.
function point_popupmenu5_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



% --- Executes during object creation, after setting all properties.
function popupmenu6_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end




% --- Executes during object creation, after setting all properties.
function edit5_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit5_Callback(hObject, eventdata, handles)
% hObject    handle to edit5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit5 as text
%        str2double(get(hObject,'String')) returns contents of edit5 as a double

global point
global point_period
global DIRECTORY
global PHI_ALL
                            
point=str2double(get(hObject,'string'))

if isnan(point)
         errordlg('You must enter a numeric value','Bad Input','modal')
elseif ~isnan(point)
   
     if point>max(1:point_period)|point<min(1:point_period)
         errordlg('Out of Range', 'Try again','modal')
            
     else
         
     end
 end
PHI_ALL=[];
cd (DIRECTORY)


% --- Executes during object creation, after setting all properties.
function popupmenu7_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu7 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on selection change in popupmenu7.
function popupmenu7_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu7 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenu7 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu7



global point
global DIRECTORY
global period
global average_points
global PHI_ALL
global saved
global ROW
global COLUMN
global frames_per_sec
global Y_ROW_MM
global X_COLUMN_MM
global one_pixel_mm
global point_period

warning off;

q=(get(hObject,'Value'));
  

N_average=average_points;

cd ('DATA_SAVED')
         CM1=[];
         for k=period(1):period(end)%period(end)
            
          CM=load(['skeleton_' int2str(k) '_point=' int2str(point) '.txt']);
      
          CM1=[CM1,[CM]];
         end 
   
      X=CM1(2,:); Y=CM1(1,:);CM1=[X;Y];

      N_total=length(X);
      
      X_triplet=[];Y_triplet=[];
      
      


  X_triplet=X(:);
  Y_triplet=Y(:);
  %for n=1:N_average
  %X_triplet(n)=mean(X_triplet(n:n+N_average-1)); 
  %Y_triplet(n)=mean(Y_triplet(n:n+N_average-1));
  %end
  
  for n=N_average+1:N_total-N_average
      %n=n
      %n-N_average
      %n+N_average
      X_triplet(n)=mean(X_triplet(n-N_average:n+N_average));
      Y_triplet(n)=mean(Y_triplet(n-N_average:n+N_average));
      
  end

  X_new=X_triplet(N_average+1:N_total-N_average);
  Y_new=Y_triplet(N_average+1:N_total-N_average);
  TIME_new=period(N_average+1:N_total-N_average);
  
  switch q
    
    case 1  % total CM trajectory
        
        cd ..
        
IMAGE=imread([int2str(period(1)) '.jpg']);
%IMAGE=rgb2gray(IMAGE);
         figure;axis_handle = axes;imshow(IMAGE);
         title(['segment = ' int2str(point) ' (green:start, blue:finish)']); 
         hold on;


X_tr=X_triplet;
Y_tr=Y_triplet;
         plot(X_tr,Y_tr,'r.',X_tr,Y_tr,'r',X_tr(1),Y_tr(1),...
             'g*',X_tr(end),Y_tr(end),'b*',X_new(1),Y_new(1),'go',X_new(end),Y_new(end),'bo')
         
         
        
    case 2    % Y vs X
        
      

figure;plot(X_triplet,period(1:end),'r.',X_triplet,period(1:end),'b',X_new(1),TIME_new(1),'go',X_new(end),TIME_new(end),'bo'); 
ylabel('frame');
xlabel('X-component(pixels)');
title(['X vs frame , segment=' int2str(point)]);

figure;plot(period(1:end),-Y_triplet,'r.',period(1:end),-Y_triplet,'b',...
   TIME_new(1),-Y_new(1),'go',TIME_new(end),-Y_new(end),'bo'); 
xlabel('frame');
ylabel('Y-component(pixels)');
title(['Y vs frame ,segment=' int2str(point)]);

        figure;plot(X_triplet,-Y_triplet,'r.',X_triplet,-Y_triplet,'b',X_triplet(1),...
            -Y_triplet(1),'g*',X_triplet(end),-Y_triplet(end),'r*',X_new(1),-Y_new(1),...
            'go',X_new(end),-Y_new(end),'bo'); 
xlabel('X-componene(pixels)');
ylabel('Y-component(pixels)');
title(['X vs Y , segment=' int2str(point) '(green *:start, red *:finish)']);



    case 3     % Speed vs Time
        
 

       %  X=X-ALL_XY(1,:);   Y=Y-ALL_XY(2,:);
       

      speedx=X_new(2:end)-X_new(1:end-1);
      speedy=Y_new(2:end)-Y_new(1:end-1);
    
      speed=sqrt(speedx.^2+speedy.^2);
figure;plot(period(N_average+1+1:N_total-N_average),(1000*one_pixel_mm*frames_per_sec*speed)',...
    'r.',period(N_average+1+1:N_total-N_average),(1000*one_pixel_mm*frames_per_sec*speed)','b');
xlabel('frame');
ylabel('speed(\mum/sec)');


          title(['speed vs frame for segment=' int2str(point)]);
     
      
   prompt={'How many bins in the speed histogram?'};

   dlgTitle='Histogram';
   lineNo=1;
   answer=inputdlg(prompt,dlgTitle,lineNo);
    N=str2double(answer);
      
figure;[f,x]=hist(1000*one_pixel_mm*frames_per_sec*speed,N);plot(x,f);xlabel('speed (\mum/sec)');ylabel('frequency');   
title(['speed histogram for segment=' int2str(point) ]);
 legend(['mean value=' num2str(1000*one_pixel_mm*frames_per_sec*mean(speed)) '\mum/sec'])


   
case 9
    
    
%
 %   A=dir(['thick*=' int2str(point) '.txt'])
  %  thick=[];
   % for i=1:length(A)
    %    thick=[thick,load(A(i).name)];
    %end
    
    pair=[];
    for i=period(1):period(end)
    pair=[pair,[i;load(['thickeness_image=' int2str(i) '_segment=' int2str(point) '.txt'])]]    ;
    end
  figure;plot(pair(1,:), 2*one_pixel_mm*pair(2,:),'.');
  xlabel('Frame');
  ylabel('Width(mm)');
   legend({['Mean value=' num2str(2*one_pixel_mm*mean(pair(2,:))) 'mm']},0);

     
   prompt={'How many bins for the width data?'};
   dlgTitle='Histogram';
   lineNo=1;
   answer=inputdlg(prompt,dlgTitle,lineNo);
    N=str2double(answer);
    figure;
    [f,x]=hist(2*one_pixel_mm*pair(2,:),N);plot(x,f);
    xlabel('Width(mm)');
    ylabel('Frequency');
    legend({['Mean value=' num2str(2*one_pixel_mm*mean(pair(2,:))) 'mm']},0);
 

case 4
    
  %  X_tr;
   % size(X_tr)
    %size(period)

    phi=atan((Y_new(2:end)-Y_new(1:end-1))./(X_new(2:end)-X_new(1:end-1)));
   % T=1:length(Y_triplet(2:end));
%size(period(1+N_average:end-2))

   figure;plot(period(N_average+1+1:N_total-N_average),phi,'r.');hold on;
   
   plot(period(N_average+1+1:N_total-N_average),phi,'b');
   xlabel('Frame');
   ylabel('Radians');
   
   
case 5
    
   prompt={'Which is the frame considered'};

   dlgTitle='frame ';
   lineNo=1; 
    answer=inputdlg(prompt,dlgTitle,lineNo);
    time_point=str2double(answer);
    
  
     if time_point>period(end)|time_point<period(1)
         errordlg('Out of Range', 'Try again','modal')
            
     else
         

    
    
      cd ..
        
IMAGE=imread([int2str(time_point) '.jpg']);
         figure;axis_handle = axes;imshow(IMAGE);
         title(['frame = ' int2str(time_point) ' (green:start, blue:finish)']); 
         hold on;
%period

k=find(period==time_point);
          plot(X_triplet,Y_triplet,'r.',X_triplet,Y_triplet,'r',X_triplet(1),Y_triplet(1),...
             'g*',X_triplet(end),Y_triplet(end),'b*',X_new(1),Y_new(1),'go',...
             X_new(end),Y_new(end),'bo');
         hold on;
         plot(X_triplet(k),Y_triplet(k),'g+')
    
       end  
       
       
       
   case 6

       phi=atan((Y_new(2:end)-Y_new(1:end-1))./(X_new(2:end)-X_new(1:end-1)));
   % T=1:length(Y_triplet(2:end));
%size(period(1+N_average:end-2))

   figure;plot(period(N_average+1+1:N_total-N_average),phi,'r.');hold on;
   
   plot(period(N_average+1+1:N_total-N_average),phi,'b');
   xlabel('Frame');
   ylabel('Radians');
   
   [x,y]=ginput;
   x=round(x);
   KA=[];
   for i=1:length(x)
KA1=find(period==x(i));
KA=[KA,KA1];
end
X1=period((KA(1)));
X2=period((KA(2)));
X_NEW=X1:X2;
alpha=-(N_average+2)+KA(1);



PHI_NEW=phi(alpha+1:alpha+(KA(2)-KA(1))+1);
figure;
plot(X_NEW,PHI_NEW,'r.');
%plot(period(N_average+1+1:N_total-N_average),phi,'r.');hold on;
   
   hold on;plot(X_NEW,PHI_NEW,'b');

   xlabel('Frame');
   ylabel('Radians');
   
   %DIFF=PHI_NEW(2:end)-PHI_NEW(1:end-1);
   
   %figure;plot(X_NEW(2:end),DIFF,'r.');hold on;plot(X_NEW(2:end),DIFF,'b');
   
   PHI_NEW=PHI_NEW';

  

  A=[X_NEW;PHI_NEW];
  
   prompt={'Type 1 if the first extreme is a minimum, otherwise type 0'};

   dlgTitle='extreme';
   lineNo=1; 
    answer=inputdlg(prompt,dlgTitle,lineNo);
    extreme=str2double(answer);
    MA=length(PHI_NEW);
    if extreme==1   %minimum
      
            ka=find(PHI_NEW==min(PHI_NEW(1:20)));
            ka=max(ka);
            start_phi=PHI_NEW(ka);
            a=0; EXTE_WHAT=[ka;-1];
            max(X_NEW)
            while ka<MA & MA-ka>8
                a=a+1;
                if mod(a,2)==0 % even
                    %look for minimum
                    if ka+20<=MA
                     ka=find(PHI_NEW==min(PHI_NEW(ka+1:ka+20)));
                     else
                         ka=find(PHI_NEW==min(PHI_NEW(ka+1:MA)));   
                     end
                     ka=max(ka);
                     EXTE_WHAT=[EXTE_WHAT,[ka;-1]];
                   
                    
                else
                    %look for maximum
                    if ka+20<=MA
                       
                     ka=find(PHI_NEW==max(PHI_NEW(ka+1:ka+20)));
                     else
                         ka=find(PHI_NEW==max(PHI_NEW(ka+1:MA)));   
                     end
                     ka=max(ka);
                     EXTE_WHAT=[EXTE_WHAT,[ka;1]];
                     
                end
                
                ka=ka;
            end
            
            EXTE_WHAT;
            
            
       
        
        
    else
   
            ka=find(PHI_NEW==max(PHI_NEW(1:20)));
            ka=max(ka);
               start_phi=PHI_NEW(ka);
               
            ka=find(PHI_NEW==min(PHI_NEW(1:20)));
            ka=max(ka);
            start_phi=PHI_NEW(ka);
            a=1; EXTE_WHAT=[ka;-1];
            max(X_NEW)
            while ka<MA  & MA-ka>8
                a=a+1;
                if mod(a,2)==0 % even
                    %look for minimum
                    if ka+20<=MA
                     ka=find(PHI_NEW==min(PHI_NEW(ka+1:ka+20)));
                     else
                         ka=find(PHI_NEW==min(PHI_NEW(ka+1:MA)));   
                     end
                     ka=max(ka);
                     EXTE_WHAT=[EXTE_WHAT,[ka;-1]];
                   
                    
                else
                    %look for maximum
                    if ka+20<=MA
                       
                     ka=find(PHI_NEW==max(PHI_NEW(ka+1:ka+20)));
                     else
                         ka=find(PHI_NEW==max(PHI_NEW(ka+1:MA)));   
                     end
                     ka=max(ka);
                     EXTE_WHAT=[EXTE_WHAT,[ka;1]];
                     
                end
                
                ka=ka;
            end
               
               
               
            

        
    end
        
    
    
    
    pa_p=find(EXTE_WHAT(2,:)==1);
      pa_m=find(EXTE_WHAT(2,:)==-1);
       
      if 1>10
      figure;plot(X_triplet,-Y_triplet,'r.',X_triplet,-Y_triplet,'b',X_triplet(1),...
            -Y_triplet(1),'g*',X_triplet(end),-Y_triplet(end),'r*',X_new(1),-Y_new(1),...
            'go',X_new(end),-Y_new(end),'bo'); 
    end
        TA_1=[];
        for k=1:length(pa_p)
            EXTE_WHAT(1,pa_p(k));
            a=EXTE_WHAT(1,pa_p(k));
       
            TA=find(TIME_new==X_NEW(a));
            TA_1=[TA_1,TA];
        end
        TA_1;
        
         TA_2=[];
        for k=1:length(pa_m)
            EXTE_WHAT(1,pa_m(k));
            a=EXTE_WHAT(1,pa_m(k));
          
            TA=find(TIME_new==X_NEW(a));
            TA_2=[TA_2,TA];
        end
        TA_2;
        
        
        
cd ..        
        IMAGE=imread([int2str(period(1)) '.jpg']);
        IMAGE=rgb2gray(IMAGE);
         figure;axis_handle = axes;imshow(IMAGE);
         title(['segment = ' int2str(point) ' (green:start, blue:finish)']); 
         hold on;
      
      
         cd (DIRECTORY)
         
         hold on;
         cd ('DATA_SAVED')
         for k=1:point_period
            
            line=load(['skeleton_' int2str(period(1)) '_line=' int2str(k) '.txt']);
            if mod(k,2)==0
                  plot(line(2,:),line(1,:),'g.'); 
                  hold on;
            else
                             plot(line(2,:),line(1,:),'b.'); hold on;
            end
            
        end
         
         
         hold on;
         
if 1>10         
X_tr=mean(X_triplet');
Y_tr=mean(Y_triplet');

X_tr=X_tr';Y_tr=Y_tr';
end

X_tr=X_triplet;
Y_tr=Y_triplet;
         plot(X_tr,Y_tr,'r.',X_tr,Y_tr,'r',X_tr(1),Y_tr(1),...
             'g*',X_tr(end),Y_tr(end),'b*',X_new(1),Y_new(1),'go',X_new(end),Y_new(end),'bo')

        
      if 1>10
        hold on;
       plot(X_new(TA_1),Y_new(TA_1),'y*');
   end
       hold on;
       plot(X_new(TA_2),Y_new(TA_2),'b+');
  
 %     cftool(X_p,Y_p)
  %  fgbdgb
     
      
    %  cdate=X_p;
     % pop=Y_p;
      %opts = fitoptions('Method','NonlinearLeastSquares','Normalize','On');
%ftype = fittype('a*sin(b*x+d)+g','options',opts);
%f1 = fit(cdate,pop,ftype);
%figure;plot(f1);hold on;plot(cdate,pop,'.')
      
       
     %  figure;cftool(X_new(TA_1(4):TA_1(5)),Y_new(TA_1(4):TA_1(5)));
     %fitresult = fit(cdate,pop,'poly2');  
      
    % mymodel = fittype('a*exp(b*n*x)+c','problem','n');
%opts = fitoptions(mymodel);
%st(opts,'normalize','on')
%[fit4,gof4,out4] = fit(cdate,pop,mymodel,opts,'problem',{2});

 
%cdate=X_new(TA_2(5):TA_1(5));
%pop=Y_new(TA_2(5):TA_1(5));
%opts = fitoptions('Method','Nonlinear','Normalize','On');
%ftype = fittype('a*sin(b*x+d)+f','options',opts);
%f1 = fit(cdate,pop,ftype);
%figure;plot(f1);hold on;plot(cdate,pop,'.')
  
  %%%%%%%%%%%%    wavelength
  

  X_wave=X_new(TA_1);
  Y_wave=Y_new(TA_1);
  
  wavelength=sqrt((X_wave(2:end)-X_wave(1:end-1)).^2+(Y_wave(2:end)-Y_wave(1:end-1)).^2);
  


  %a={['wavelength=' num2str(mean(wavelength)) 'pixels']};
  %legend(a,0);
  
 %%%%%%%%%%%%%%%%  computation of amplitude

 AMPLITUDE=[];
 PHI_ALL=[];
 for i=1:length(TA_1)-2
    
 
       PHI=atan((Y_new(TA_1(i+1))-Y_new(TA_1(i)))/(X_new(TA_1(i+1))-X_new(TA_1(i))));
       PHI_ALL=[PHI_ALL,PHI];
       X_p=cos(PHI)*X_new(TA_1(i):TA_1(i+1))+sin(PHI)*Y_new(TA_1(i):TA_1(i+1));
       Y_p=-sin(PHI)*X_new(TA_1(i):TA_1(i+1))+cos(PHI)*Y_new(TA_1(i):TA_1(i+1));
       AMPLITUDE=[AMPLITUDE,abs(max(Y_p)-min(Y_p))/2];
       
      %%%%%%%%%%%%%%   if you want the pattern (sinusoidal) to appear 
       figure;plot(one_pixel_mm*X_p,one_pixel_mm*Y_p);
       xlabel('horizontal displacement');
       ylabel('vertical displacement')
       
   end

 AMPLITUDE;
   
 a={['wavelength=' num2str(one_pixel_mm*mean(wavelength)) 'mm']};
 b={['amplitude=' num2str(one_pixel_mm*mean(AMPLITUDE)) 'mm']};
  legend([a,b],0);
  
 
case 7
  %PHI_ALL
  %if length(PHI_ALL)==0
   %    msgbox('Run the previous option first');
   %else
      figure;plot(1:length(PHI_ALL),PHI_ALL,'r');hold on;plot(1:length(PHI_ALL),PHI_ALL,'b*');
      xlabel('wavelength #')
      ylabel('angle change')
      %end
   
       
      %end

      case 8
          
          cd ..

          %computation of position of CM
            cd ('DATA_SAVED')
          
      
          N1=load('number_of_time_points.txt');
          
          %  CM is on segment (N1-1)/2+1;
          
          N_sk=(N1-1)/2+1;
          point_cm=N_sk;
       %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
       
   
          
          % position of CM of selected  segment is 
       
          X_CM_N=[];Y_CM_N=[]; X_CM_a=[];Y_CM_a=[];
        for k=period(1):period(end)
          CM=load(['skeleton_' int2str(k) '_point=' int2str(point) '.txt']);
      
       X_CM_s=CM(2);
       Y_CM_s=CM(1);
       
        X_CM_N=[X_CM_N,X_CM_s];Y_CM_N=[Y_CM_N,Y_CM_s];
        
        
     
          
          % position of CM in segment N1-1)/2+1 is 
          
        
          CM=load(['skeleton_' int2str(k) '_point=' int2str(point_cm) '.txt']);
      X_CM=CM(2);
       Y_CM=CM(1);
       X_CM_a=[X_CM_a,X_CM];Y_CM_a=[Y_CM_a,Y_CM];
        
        
        
       
   end
   
   DIST=sqrt((X_CM_N-X_CM_a).^2+(Y_CM_N-Y_CM_a).^2);
   
   figure;plot(period,one_pixel_mm*DIST,'.');
   xlabel('Frame');
   ylabel('Distance(mm)');
    legend(['Mean distance=' num2str(one_pixel_mm*mean(DIST)) 'mm'],0)
    

   
       % figure;imshow(IMAGE);
   %hold on;plot(X_CM_s,Y_CM_s,'r*'),hold on;plot(X_CM,Y_CM,'g*')
  

          
        
      
   prompt={'How many bins in the distance of segment to CM histogram?'};
   dlgTitle='Histogram';
   lineNo=1;
   answer=inputdlg(prompt,dlgTitle,lineNo);
    N=str2double(answer);
          
    
          figure;[f,x]=hist(DIST,N);plot(x,one_pixel_mm*f);
          xlabel('Distance(mm)');
          ylabel('Frequency');
           legend(['Mean distance=' num2str(one_pixel_mm*mean(DIST)) 'mm'],0)
    
          
  end      
          
         %msgbox('currently not working'); 


cd (DIRECTORY)


% --- Executes during object creation, after setting all properties.
function edit6_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit6_Callback(hObject, eventdata, handles)
% hObject    handle to edit6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit6 as text
%        str2double(get(hObject,'String')) returns contents of edit6 as a double


  global DIRECTORY
  global average_points
  global period
global PHI_ALL
average_points=str2double(get(hObject,'string'));


if isnan(average_points)
         errordlg('You must enter a numeric value','Bad Input','modal')

   

 end
PHI_ALL=[];
cd (DIRECTORY)



% --- Executes on button press in pushbutton5.
function pushbutton5_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

global DIRECTORY

button3 = questdlg('Do you want to quit GIU?',... 
           'Close GUI','OK', 'No', 'No'); 
       if strcmp(button3,'OK')
           
           %close(handles.intragui_OpeningFcn)
           closereq
       end
       

cd (DIRECTORY)


% --- Executes during object creation, after setting all properties.
function popupmenu9_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu9 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on selection change in popupmenu9.
function popupmenu9_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu9 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenu9 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu9


global DIRECTORY
global period
global ROW
global COLUMN
global frames_per_sec
global Y_ROW_MM
global X_COLUMN_MM
global one_pixel_mm


q=(get(hObject,'Value'));




switch q
    
    case 1    % area
  
        cd ('DATA_SAVED')
    
    %open proper file

    AREA=[];
    for i=period(1):period(end)
    AREA=[AREA,load(['area_' int2str(i) '.txt'])];    
    end
    
figure;plot(period,one_pixel_mm*one_pixel_mm*AREA,'.');
xlabel('frame number');
ylabel('area (mm^2)');
legend([num2str(one_pixel_mm*one_pixel_mm*mean(AREA)) 'mm^2'],0);

   
   prompt={'How many bins for the area data?'};
   dlgTitle='Histogram';
   lineNo=1;
   answer=inputdlg(prompt,dlgTitle,lineNo);
    N=str2double(answer);
figure;[f,x]=hist(AREA,N);plot(one_pixel_mm*one_pixel_mm*x,f);
xlabel('area (mm^2)');
ylabel('frequency');
legend([num2str(one_pixel_mm*one_pixel_mm*mean(AREA)) 'mm^2'],0);
 time_umb_ini=findobj(gcbf,'Tag','edit13');
     set(time_umb_ini,'String',sprintf('%s',char([num2str(one_pixel_mm*one_pixel_mm*mean(AREA))])))

case 2  % thickness
    %open proper file

      cd ('DATA_SAVED')
    A=dir(['thick*']);
    thick=[];
    for i=1:length(A)
        thick=[thick,load(A(i).name)];
    end
    
     
    thick=2*thick;
    
   prompt={'How many bins for the width data?'};
   dlgTitle='Histogram';
   lineNo=1;
   answer=inputdlg(prompt,dlgTitle,lineNo);
    N=str2double(answer);
    figure;
    [f,x]=hist(thick,N);plot(one_pixel_mm*x,f);

    xlabel('Width (mm)');
    ylabel('Frequency');
    legend({['Mean value=' num2str(one_pixel_mm*mean(thick)) 'mm']},0);
      time_umb_ini=findobj(gcbf,'Tag','edit12');
     set(time_umb_ini,'String',sprintf('%s',char([num2str(one_pixel_mm*mean(thick))])))
    
    
    
    
    
case 3 %  length
    %open proper file
   cd ('DATA_SAVED')
    
    %open proper file

    LENGTH=[];
    for i=period(1):period(end)
    LENGTH=[LENGTH,load(['length_' int2str(i) '.txt'])];    
    end
    
figure;plot(period,one_pixel_mm*LENGTH,'.');
xlabel('Frame');
ylabel('Length (mm)');
legend(['Mean Value=' num2str(one_pixel_mm*mean(LENGTH)) 'mm'],0);

   
   prompt={'How many bins for the length data?'};
   dlgTitle='Histogram';
   lineNo=1;
   answer=inputdlg(prompt,dlgTitle,lineNo);
    N=str2double(answer);
figure;[f,x]=hist(LENGTH,N);plot(one_pixel_mm*x,f);
xlabel('length (mm)');
ylabel('frequency');
legend(['Mean Value=' num2str(one_pixel_mm*mean(LENGTH)) 'mm'],0);
 time_umb_ini=findobj(gcbf,'Tag','edit11');
     set(time_umb_ini,'String',sprintf('%s',char([num2str(one_pixel_mm*mean(LENGTH))])))
    
case 4 % distance covered by warm

    cd ('DATA_SAVED')
          

          
          

          N1=load('number_of_time_points.txt');
          point=(N1-1)/2+1;X_CM_N=[];Y_CM_N=[];
          for k=period(1):period(end)
          CM=load(['skeleton_' int2str(k) '_point=' int2str(point) '.txt']);
      
       X_CM_s=CM(2);
       Y_CM_s=CM(1);
       
        X_CM_N=[X_CM_N,X_CM_s];Y_CM_N=[Y_CM_N,Y_CM_s];
    end
    
    DIST=sum(sqrt((X_CM_N(2:end)-X_CM_N(1:end-1)).^2+(Y_CM_N(2:end)-Y_CM_N(1:end-1)).^2));
    
    
          time_umb_ini=findobj(gcbf,'Tag','edit10');
     set(time_umb_ini,'String',sprintf('%s',char([num2str(one_pixel_mm*DIST)])))
         
       %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
       

          
          
         
    
    
case 5
     cd ('DATA_SAVED')
  N1=load('number_of_time_points.txt');
  point=N1;
          %point=(N1-1)/2+1;
          X_CM_N=[];Y_CM_N=[];
          %
          % position of CM of selected  segment is 
       
          X_CM_N=[];Y_CM_N=[]; X_CM_a=[];Y_CM_a=[];
        for k=period(1):period(end)
          CM=load(['skeleton_' int2str(k) '_point=' int2str(point) '.txt']);
      
       X_CM_s=CM(2);
       Y_CM_s=CM(1);
       
        X_CM_N=[X_CM_N,X_CM_s];Y_CM_N=[Y_CM_N,Y_CM_s];
        
        
     
          
          % position of CM in segment N1-1)/2+1 is 
          
        
          CM=load(['skeleton_' int2str(k) '_point=' int2str(1) '.txt']);
      X_CM=CM(2);
       Y_CM=CM(1);
       X_CM_a=[X_CM_a,X_CM];Y_CM_a=[Y_CM_a,Y_CM];
        
        
        
       
   end
   
   DIST=sqrt((X_CM_N-X_CM_a).^2+(Y_CM_N-Y_CM_a).^2);
   
   figure;plot(period,one_pixel_mm*DIST,'.');
   xlabel('frame');
   ylabel('Distance (mm)');
   legend(['Mean distance=' num2str(one_pixel_mm*mean(DIST)) 'mm'],0)
   

   
       % figure;imshow(IMAGE);
   %hold on;plot(X_CM_s,Y_CM_s,'r*'),hold on;plot(X_CM,Y_CM,'g*')
  

          
        
      
   prompt={'How many bins for the distance of head-tail?'};
   dlgTitle='Histogram';
   lineNo=1;
   answer=inputdlg(prompt,dlgTitle,lineNo);
    N=str2double(answer);
          
    
          figure;[f,x]=hist(DIST,N);plot(one_pixel_mm*x,f);
          xlabel('Distance (mm)');
          ylabel('Frequency');
    legend(['Mean distance=' num2str(one_pixel_mm*mean(DIST)) 'pixels'],0)
    
     time_umb_ini=findobj(gcbf,'Tag','edit14');
     set(time_umb_ini,'String',sprintf('%s',char([num2str(one_pixel_mm*mean(DIST))])))
end
cd (DIRECTORY)


% --- Executes during object creation, after setting all properties.
function edit8_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit8 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit8_Callback(hObject, eventdata, handles)
% hObject    handle to edit8 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit8 as text
%        str2double(get(hObject,'String')) returns contents of edit8 as a double


% --- Executes during object creation, after setting all properties.
function edit9_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit9 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit9_Callback(hObject, eventdata, handles)
% hObject    handle to edit9 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit9 as text
%        str2double(get(hObject,'String')) returns contents of edit9 as a double


% --- Executes during object creation, after setting all properties.
function edit10_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit10 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit10_Callback(hObject, eventdata, handles)
% hObject    handle to edit10 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit10 as text
%        str2double(get(hObject,'String')) returns contents of edit10 as a double


% --- Executes during object creation, after setting all properties.
function edit11_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit11 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit11_Callback(hObject, eventdata, handles)
% hObject    handle to edit11 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit11 as text
%        str2double(get(hObject,'String')) returns contents of edit11 as a double


% --- Executes during object creation, after setting all properties.
function edit12_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit12 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit12_Callback(hObject, eventdata, handles)
% hObject    handle to edit12 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit12 as text
%        str2double(get(hObject,'String')) returns contents of edit12 as a double


% --- Executes during object creation, after setting all properties.
function edit13_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit13 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit13_Callback(hObject, eventdata, handles)
% hObject    handle to edit13 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit13 as text
%        str2double(get(hObject,'String')) returns contents of edit13 as a double


% --- Executes during object creation, after setting all properties.
function edit14_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit14 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit14_Callback(hObject, eventdata, handles)
% hObject    handle to edit14 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit14 as text
%        str2double(get(hObject,'String')) returns contents of edit14 as a double


% --- Executes during object creation, after setting all properties.
function edit15_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit15 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit15_Callback(hObject, eventdata, handles)
% hObject    handle to edit15 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit15 as text
%        str2double(get(hObject,'String')) returns contents of edit15 as a double


% --- Executes during object creation, after setting all properties.
function edit16_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit16 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit16_Callback(hObject, eventdata, handles)
% hObject    handle to edit16 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit16 as text
%        str2double(get(hObject,'String')) returns contents of edit16 as a double


% --- Executes during object creation, after setting all properties.
function edit17_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit17 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit17_Callback(hObject, eventdata, handles)
% hObject    handle to edit17 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit17 as text
%        str2double(get(hObject,'String')) returns contents of edit17 as a double


% --- Executes on button press in radiobutton1.
function radiobutton1_Callback(hObject, eventdata, handles)
% hObject    handle to radiobutton1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radiobutton1


% --- Executes on button press in radiobutton2.
function radiobutton2_Callback(hObject, eventdata, handles)
% hObject    handle to radiobutton2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radiobutton2


% --- Executes during object creation, after setting all properties.
function edit18_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit18 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit18_Callback(hObject, eventdata, handles)
% hObject    handle to edit18 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit18 as text
%        str2double(get(hObject,'String')) returns contents of edit18 as a double


% --- Executes during object creation, after setting all properties.
function edit19_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit19 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit19_Callback(hObject, eventdata, handles)
% hObject    handle to edit19 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit19 as text
%        str2double(get(hObject,'String')) returns contents of edit19 as a double


% --- Executes during object creation, after setting all properties.
function edit20_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit20 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit20_Callback(hObject, eventdata, handles)
% hObject    handle to edit20 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit20 as text
%        str2double(get(hObject,'String')) returns contents of edit20 as a double


% --- Executes during object creation, after setting all properties.
function popupmenu10_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu10 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on selection change in popupmenu10.
function popupmenu10_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu10 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenu10 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu10


% --------------------------------------------------------------------
function Untitled_1_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


